﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace HospitalDataDemo
{
    public partial class frmHospitalData : Form
    {
        public frmHospitalData()
        {
            InitializeComponent();
        }

        private void frmHospitalData_Load(object sender, EventArgs e)
        {
            var docs =
                from doc in new HospitalDataContext().HospitalStaffs
                where doc.Position == "Lekarz"
                select doc;

            lbDoctors.DataSource = docs;
            lbDoctors.DisplayMember = "Name";
            lbDoctors.ValueMember = "HospitalStaffID";
        }

        private void lbDoctors_SelectedIndexChanged(object sender, EventArgs e)
        {
            dgvPatients.DataSource =
                from patient in new HospitalDataContext().Patients
                where patient.DoctorID == lbDoctors.SelectedIndex
                select patient;
        }


    }
}
